/* 
	Abstract Serial Channel Over USB, 
	by Mauro Grassi, October 2010.
	
	Presents a serial pipe over USB transport.
	Useful for diagnostics and debugging 
	without a serial port...

	This is a FIFO pipe with commit functionality on newline, 
	by Mauro Grassi, October 2010.

*/

#include "usb_device.h"
#include "usb.h"
#include "usb_function_generic.h"
#include "usb_config.h"
#include "serialUSB.h"
#include "mystring.h"
#include "Delay.h"
#include "main.h"
#include "uart.h"
#include "boot.h"

#pragma udata serialusbdata

unsigned char 	serialPipe[MAX_SERIAL_PIPE_LENGTH];
unsigned char   serialPipePutPtr;
unsigned char 	serialPipeGetPtr;
unsigned char 	serialPipeStatus;
  
#pragma code usercode

#if 0
void showPipeBuffer()
{
	unsigned int  i;
	unsigned char g;
	
	putrsUART((const rom char*)" Pipe: [");
	i=serialPipeGetPtr;
	while(i!=serialPipePutPtr)
	{
		g=serialPipe[i];
		if(i<(MAX_SERIAL_PIPE_LENGTH-1))i++; else i=0;
		if(g=='\r')
		{
		putcUART('\\');
		putcUART('r');		
		}
		else
		if(g=='\n')
		{
		putcUART('\\');
		putcUART('n');
		}
		else
		{
			putcUART(g);
		}
	}
	putrsUART((const rom char*)"]\r\n");
}
#endif

unsigned char serialPipeGet(void)
{
	unsigned char g;
	
	if(serialPipeGetPtr!=serialPipePutPtr)
	{
		g=serialPipe[serialPipeGetPtr];
		if(serialPipeGetPtr<(MAX_SERIAL_PIPE_LENGTH-1))
		serialPipeGetPtr++; else serialPipeGetPtr=0;
	}
	else
	{
		/* nothing to get */
		serialPipeStatus|=SERIAL_PIPE_UNDERFLOW;
		g='\0';
	}
	return g;
}

void serialPipePut(unsigned char g)
{
	unsigned char x;
	
	x=serialPipePutPtr;
	if(x<(MAX_SERIAL_PIPE_LENGTH-1))x++; else x=0;

	if(x==serialPipeGetPtr)
	{
		/* Make Room If Possible */	
		serialPipeGet();
		serialPipeStatus|=SERIAL_PIPE_OVERFLOW;
	}
	/* Adds another char */
	serialPipe[serialPipePutPtr]=g;
	serialPipePutPtr=x;

}

void flushSerialUSB(void)
{
	unsigned int length;
	unsigned char c;
	
	/* reset the buffer */
    length=0;
	c=serialPipeGet();
	while((c!='\0')&&((length+4)<SIZE_USB_PACKET))
	{
		INPacket.data[length+4]=c;
		length++;
		c=serialPipeGet();
	}
	INPacket.data[1]=serialPipeStatus;
	serialPipeStatus=SERIAL_PIPE_OK;
	INPacket.data[2]=(unsigned char)(length);
	INPacket.data[3]=(unsigned char)(length>>8);
}

void sendCharSerialUSB(unsigned char c)
{
	if((hostAlive>0)&&(USBDeviceState==CONFIGURED_STATE))
	{
		serialPipePut(c);
	}	
	else
	{
	
	}
}

#if 0
void sendRamStringSerialUSB(unsigned char* ramString)
{
	while((*ramString)!='\0')
	{
		sendCharSerialUSB(*ramString++);
	}
}

void sendRomStringSerialUSB(unsigned const rom char* romString)
{
	while((*romString)!='\0')
	{
		sendCharSerialUSB(*romString++);
	}
}
#endif

void initSerialUSB(void)
{
	/* initialize the serial pipe */
	serialPipeStatus=SERIAL_PIPE_OK;
	serialPipePutPtr=0;
	serialPipeGetPtr=0;
}
